//=============================================================================
// TestBlock, Deployed.
//=============================================================================
class RedstoneWireBlockDeployed extends BlockDeployed;

function UpdateBlock()
{
 Super.UpdateBlock();
 
 if (!CheckDependancy())
 {
  Destroy();
  UpdateNeighbors();
 }

 ScaleGlow = 0.2 * int(bHasCharge) * (ChargeStrength + 1);
}

function UpdateCharge()
{
 local int i, BestCharge;
 local BlockDeployed Best;
 
 for(i=0; i<6; i++)
 {
  if (CurNeighbors[i].bHasCharge && CurNeighbors[i].ChargeStrength > 0)
  {
   if (CurNeighbors[i].ChargeStrength > BestCharge && CurNeighbors[i].ChargeSource != Self)
   {
    Best = CurNeighbors[i];
    BestCharge = CurNeighbors[i].ChargeStrength;
   }
  }
 }
 
 if (Best != None && BestCharge > 0)
 {
  bHasCharge = True;
  ChargeSource = Best;
  ChargeStrength = BestCharge - 1;
 }
 if (Best == None || BestCharge <= 0)
 {
  bHasCharge = False;
  ChargeSource = None;
  ChargeStrength = 0;
 }
 
 ScaleGlow = 0.2 * int(bHasCharge) * (ChargeStrength + 1);
}

function bool CheckDependancy()
{
 local int i;
 
 if (CurNeighbors[1] != None) //we read downwards only.
 {
  return True;
 }
 
 return False;
}

defaultproperties
{
     DrawMult=0.150000
     bCanBranch=False
}
